#!/bin/bash
#Скрипт для включения/выключения логирования sql в БД mysql
#Вызов:
#db-log.sh [param]
#	param = help 	- вывести справку
#	param = start	- включить логирование
#	param = stop	- остановить логирование

#############################################################################
#Настройки
log_file='/tmp/mysql.log'	#Файл лога.

#############################################################################
#Функция вывода информации о скрипте
funcabuot()
{
	echo "Скрипт для включения логирования изменений в БД mysql"
	echo ""
	echo "Вызов: db-shot.sh [param]"
	echo "Параметры:"
	echo "  help      - эта справка"
	echo "  start     - стартовать логирование"
	echo "  stop      - остановить логирование"
	echo ""
	echo "Разработал: Башкиров Александр http://alib.spb.ru"
}

#Проверяем параметры
#Вывод приветствия
if [ "$1" = "help" ] || [ "$1" = "--help" ] || [ "$1" = "" ]
then
	funcabuot
	exit 1
fi;

if [ "$1" = "start" ] || [ "$1" = "--start" ]
then
	#Получаем имя пользователя и пароль mysql
	#Вводим имя пользователя, тут все просто - ничего не надо маскировать
	echo "Введите имя пользователя mysql с правами чтения глобальных переменных (root)"
	read mysqluser
	#Вводим пароль - его как раз надо прятать
	#Рецепт ввода пароля без изменени, отсюда: http://debianforum.ru/index.php?topic=5261.0
	echo "Введите пароль пользователя $mysqluser"
	PASSWORD=""
	while
	read -s -n1 BUFF
	[[ -n $BUFF ]]
	do
	    # 127 - backspace ascii code 
	    if [[ `printf "%d\n" \'$BUFF` == 127 ]]
	    then
		PASSWORD="${PASSWORD%?}"
		echo -en "\b \b"
	    else
		PASSWORD=$PASSWORD$BUFF
		echo -en "*"
	    fi
	done

	#Проверяем, что лог пишется в нужное нам место
	mysql_var_general_log_file=`mysql -u $mysqluser  -p$PASSWORD -e "SHOW VARIABLES LIKE \"general_log_file%\";" | grep 'general_log_file' | awk '{print $2}'`
	#Если лог пишется не туда - исправляем это
	if [ "$mysql_var_general_log" != "$log_file" ]; then
		mysql -u $mysqluser  -p$PASSWORD -e "SET GLOBAL general_log_file = '$log_file';"
	fi

	#Проверяем, что в БД включено логирование 
	mysql_var_general_log=`mysql -u $mysqluser  -p$PASSWORD -e "SHOW VARIABLES LIKE \"general_log%\";" | grep 'general_log' | grep -v 'general_log_file'| awk '{print $2}'`
	#Если логирование не включено, вкдючаем его
	if [ $mysql_var_general_log == 'OFF' ]; then
		mysql -u $mysqluser  -p$PASSWORD -e "SET GLOBAL general_log = 'ON';"
	fi
	echo ""
	echo "Логирование включено. Лог пишется в файл $log_file"
	exit 0
fi

if [ "$1" = "stop" ] || [ "$1" = "--stop" ]
then
	#Вводим параметры доступа к БД
	#Вводим имя пользователя, тут все просто - ничего не надо маскировать
	echo "Введите имя пользователя mysql с правами чтения глобальных переменных (root)"
	read mysqluser
	#Вводим пароль - его как раз надо прятать
	#Рецепт ввода пароля без изменени, отсюда: http://debianforum.ru/index.php?topic=5261.0
	echo "Введите пароль пользователя $mysqluser"
	PASSWORD=""
	while
	read -s -n1 BUFF
	[[ -n $BUFF ]]
	do
	    # 127 - backspace ascii code 
	    if [[ `printf "%d\n" \'$BUFF` == 127 ]]
	    then
		PASSWORD="${PASSWORD%?}"
		echo -en "\b \b"
	    else
		PASSWORD=$PASSWORD$BUFF
		echo -en "*"
	    fi
	done

	#Проверяем, что в БД включено логирование 
	mysql_var_general_log=`mysql -u $mysqluser  -p$PASSWORD -e "SHOW VARIABLES LIKE \"general_log%\";" | grep 'general_log' | grep -v 'general_log_file'| awk '{print $2}'`
	#Если логирование включено, выключаем его
	if [ $mysql_var_general_log == 'ON' ]; then
		mysql -u $mysqluser  -p$PASSWORD -e "SET GLOBAL general_log = 'OFF';"
	fi
	echo ""
	echo "Логирование выключено."
	exit 0
fi

funcabuot

